/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.client.ClientTickHandler;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.Util;

public class DataDebug {
    public long started = 0L;
    public long startedTicks = 0L;
    private final Map<Side, Debug> data = new HashMap<Side, Debug>();

    @Nonnull
    private static String getKey(Object target) {
        if (target == null) {
            return "";
        }
        if (target instanceof String) {
            return (String)target;
        }
        if (target instanceof EntityPlayer) {
            return "Players";
        }
        if (target instanceof EntityNPCInterface) {
            return "NPC";
        }
        if (target instanceof Entity) {
            return "MOBs";
        }
        if (target instanceof Class) {
            return ((Class)target).getSimpleName();
        }
        return target.getClass().getSimpleName();
    }

    public void end(Object target) {
        this.end(target, "");
    }

    public void end(Object target, String addedToMethodName) {
        if (!CustomNpcs.DebugMonitoring) {
            return;
        }
        StackTraceElement caller = Thread.currentThread().getStackTrace()[2];
        String obj = caller.getClassName();
        Side side = caller.getMethodName().equals("findChunksForSpawning") || caller.getMethodName().equals("performWorldGenSpawning") ? Side.SERVER : Util.instance.getSide();
        String trg = DataDebug.getKey(target);
        int dotPos = obj.lastIndexOf(".") + 1;
        if (dotPos > 0) {
            obj = obj.substring(dotPos);
        }
        if (trg.equals("Packets")) {
            this.data.get(side).start(trg, DataDebug.getKey(obj));
        } else {
            if (!trg.isEmpty()) {
                trg = "_" + trg;
            }
            String methodName = this.getMethodName(caller.getMethodName(), addedToMethodName);
            this.data.get(side).end(DataDebug.getKey(obj), methodName + trg);
        }
    }

    public void start(Object target) {
        this.start(target, "");
    }

    public void start(Object target, String addedToMethodName) {
        if (!CustomNpcs.DebugMonitoring) {
            return;
        }
        StackTraceElement caller = Thread.currentThread().getStackTrace()[2];
        String obj = caller.getClassName();
        Side side = caller.getMethodName().equals("findChunksForSpawning") || caller.getMethodName().equals("performWorldGenSpawning") ? Side.SERVER : Util.instance.getSide();
        String trg = DataDebug.getKey(target);
        int dotPos = obj.lastIndexOf(".") + 1;
        if (dotPos > 0) {
            obj = obj.substring(dotPos);
        }
        if (trg.equals("Packets")) {
            this.data.get(side).start(trg, DataDebug.getKey(obj));
        } else {
            if (!trg.isEmpty()) {
                trg = "_" + trg;
            }
            String methodName = this.getMethodName(caller.getMethodName(), addedToMethodName);
            this.data.get(side).start(DataDebug.getKey(obj), methodName + trg);
        }
    }

    private String getMethodName(String method, String added) {
        if (method.startsWith("lambda$") && (method = method.substring(method.indexOf("$") + 1)).contains("$")) {
            method = method.substring(0, method.indexOf("$"));
        }
        if (method.contains("npcs$")) {
            if ((method = method.substring(method.lastIndexOf("npcs$") + 5)).lastIndexOf("Start") != -1) {
                method = method.substring(0, method.lastIndexOf("Start"));
            }
            if (method.lastIndexOf("End") != -1) {
                method = method.substring(0, method.lastIndexOf("End"));
            }
        }
        return method + "(" + added + ")";
    }

    public DataDebug() {
        this.clear();
    }

    public void stop() {
        if (!CustomNpcs.DebugMonitoring) {
            return;
        }
        for (Side side : this.data.keySet()) {
            for (String k : this.data.get(side).starters.keySet()) {
                this.data.get(side).end(k.substring(0, k.indexOf(58)), k.substring(k.indexOf(58) + 1));
            }
        }
    }

    public void clear() {
        this.stop();
        this.data.put(Side.SERVER, new Debug());
        this.data.put(Side.CLIENT, new Debug());
    }

    public List<String> logging() {
        StringBuilder tempInfo;
        LogWriter.info("Output full debug info CustomNpcs:");
        LogWriter.info("Showing Monitoring results for ANY side. { Side: [Target.Method names; Runs; Average time] }:");
        StringBuilder maxInfo = new StringBuilder("Output maximums from debug info ").append("CustomNpcs").append(":");
        this.stop();
        boolean start = false;
        ArrayList<String> list = new ArrayList<String>();
        for (Side side : this.data.keySet()) {
            String temp;
            if (start) {
                LogWriter.info("----   ----   ----");
            }
            LogWriter.info("Side: " + side.name());
            ArrayList events = new ArrayList(this.data.get(side).times.keySet());
            Collections.sort(events);
            int i = 0;
            long max = Long.MIN_VALUE;
            Object[][] maxInSide = new Object[2][4];
            for (String eventName : events) {
                Debug dd = this.data.get(side);
                ArrayList targets = new ArrayList(((Map)this.data.get(side).times.get(eventName)).keySet());
                Collections.sort(targets);
                StringBuilder log = new StringBuilder();
                if (targets.size() > 1) {
                    log.append("\n");
                }
                int s = 0;
                for (String target : targets) {
                    Long[] time = (Long[])((Map)this.data.get(side).times.get(eventName)).get(target);
                    if (time[0] <= 0L) {
                        time[0] = 1L;
                    }
                    if (target.lastIndexOf("_") != -1) {
                        log.append("  [").append(target, 0, target.lastIndexOf("_")).append(", ").append(target.substring(target.lastIndexOf("_") + 1));
                    } else {
                        log.append("  [").append(target);
                    }
                    log.append(", ").append(time[0]).append(", ").append(Util.instance.ticksToElapsedTime(time[1], true, false, false)).append("]");
                    if (s < targets.size() - 1) {
                        log.append(";\n");
                    }
                    if (time[1] == dd.max) {
                        maxInSide[0][0] = eventName;
                        maxInSide[0][1] = target;
                        maxInSide[0][2] = time[0];
                        maxInSide[0][3] = time[1];
                    }
                    if (max < time[0]) {
                        max = time[0];
                        maxInSide[1][0] = eventName;
                        maxInSide[1][1] = target;
                        maxInSide[1][2] = time[0];
                        maxInSide[1][3] = time[1];
                    }
                    ++s;
                }
                LogWriter.info(" [" + (i + 1) + "/" + events.size() + "] - \"" + eventName + "\": " + log);
                ++i;
            }
            if (maxInSide[0][0] != null) {
                tempInfo = new StringBuilder(TextFormatting.GRAY.toString()).append(" \"").append(TextFormatting.RESET).append(side.name()).append(TextFormatting.GRAY).append("\" a long time [").append(TextFormatting.BLUE).append(maxInSide[0][0]).append(TextFormatting.GRAY).append(".").append(TextFormatting.DARK_GREEN).append(maxInSide[0][1]).append(TextFormatting.GRAY).append("; runs: ").append(TextFormatting.GOLD).append(maxInSide[0][2]).append(TextFormatting.GRAY).append("; time = ").append(TextFormatting.RESET).append(Util.instance.ticksToElapsedTime((Long)maxInSide[0][3], true, true, false)).append(TextFormatting.GRAY).append("]");
                temp = "\n" + Util.instance.deleteColor(tempInfo.toString());
                maxInfo.append(temp);
                list.add(tempInfo.toString());
            }
            if (maxInSide[1][0] != null) {
                tempInfo = new StringBuilder(TextFormatting.DARK_GRAY.toString()).append(" \"").append(TextFormatting.RESET).append(side.name()).append(TextFormatting.GRAY).append("\" most often [").append(TextFormatting.BLUE).append(maxInSide[1][0]).append(TextFormatting.GRAY).append(".").append(TextFormatting.DARK_GREEN).append(maxInSide[1][1]).append(TextFormatting.GRAY).append("; runs: ").append(TextFormatting.GOLD).append(maxInSide[1][2]).append(TextFormatting.GRAY).append("; time = ").append(TextFormatting.RESET).append(Util.instance.ticksToElapsedTime((Long)maxInSide[1][3], true, true, false)).append(TextFormatting.GRAY).append("]");
                temp = "\n" + Util.instance.deleteColor(tempInfo.toString());
                maxInfo.append(temp);
                list.add(tempInfo.toString());
            }
            start = true;
        }
        list.add("Caches:");
        LogWriter.info("Caches:");
        if (this.started != 0L) {
            long ticks;
            String side;
            long time = (System.currentTimeMillis() - this.started) / 50L;
            if (CustomNpcs.Server != null) {
                side = "Server";
                ticks = CustomNpcs.Server.func_71218_a(0).func_82737_E() - this.startedTicks;
            } else {
                side = "Client";
                ticks = ClientTickHandler.ticks - this.startedTicks;
            }
            tempInfo = new StringBuilder(TextFormatting.GRAY.toString()).append(side).append(" system running time ").append(Util.instance.ticksToElapsedTime(time, false, true, false)).append(TextFormatting.GRAY).append(", game running time ").append(Util.instance.ticksToElapsedTime(ticks, false, true, false)).append(TextFormatting.GRAY).append(" (").append(TextFormatting.BLUE).append((double)Math.round((double)Math.abs(time - ticks) / (double)time * 1000.0) / 1000.0).append(TextFormatting.GRAY).append("%)");
            list.add(tempInfo.toString());
            LogWriter.info(Util.instance.deleteColor(tempInfo.toString()));
        }
        MemoryUsage memUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        tempInfo = new StringBuilder(TextFormatting.GRAY.toString()).append("Current total memory: ").append(TextFormatting.RESET).append(Util.instance.getTextReducedNumber(memUsage.getUsed(), false, true, true)).append(TextFormatting.GRAY).append(" / ").append(TextFormatting.RESET).append(Util.instance.getTextReducedNumber(memUsage.getMax(), false, true, true)).append(TextFormatting.GRAY).append(" byte");
        list.add(tempInfo.toString());
        LogWriter.info(Util.instance.deleteColor(tempInfo.toString()));
        LogWriter.info(maxInfo);
        return list;
    }

    public static class Debug {
        private long max = 0L;
        private final Map<String, Long> starters = new HashMap<String, Long>();
        private final Map<String, Map<String, Long[]>> times = new HashMap<String, Map<String, Long[]>>();

        public void end(String eventName, String eventTarget) {
            Long[] arr;
            if (eventName == null || eventTarget == null) {
                return;
            }
            String key = Thread.currentThread().getId() + ":" + eventName + ":" + eventTarget;
            if (!this.starters.containsKey(key)) {
                LogWriter.debug("Double ending debug \"" + key + "\"");
                return;
            }
            if (!this.times.containsKey(eventName)) {
                this.times.put(eventName, new HashMap());
            }
            if (!this.times.get(eventName).containsKey(eventTarget)) {
                this.times.get(eventName).put(eventTarget, new Long[]{0L, 0L});
            }
            Long[] longArray = arr = this.times.get(eventName).get(eventTarget);
            Long l = longArray[0];
            Long l2 = longArray[0] = Long.valueOf(longArray[0] + 1L);
            long r = System.currentTimeMillis() - this.starters.get(key);
            if (arr[1] < r) {
                arr[1] = r;
            }
            if (!(this.max >= r || key.toLowerCase().contains("register") || key.toLowerCase().contains("load") || key.toLowerCase().contains("<init>"))) {
                this.max = r;
            }
            this.times.get(eventName).put(eventTarget, arr);
            this.starters.remove(key);
        }

        public void start(String eventName, String eventTarget) {
            if (eventName == null || eventTarget == null) {
                return;
            }
            String key = Thread.currentThread().getId() + ":" + eventName + ":" + eventTarget;
            if (this.starters.containsKey(key)) {
                LogWriter.debug("Double starting debug \"" + key + "\"");
            }
            this.starters.put(key, System.currentTimeMillis());
        }
    }
}

